<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $vehicle_id = $_POST['vehicle_id'];
    $service_date = $_POST['service_date'];
    $mileage = $_POST['mileage'];
    $type = $_POST['service_type'];
    $performed_by = $_POST['performed_by'];

    $stmt = $pdo->prepare("INSERT INTO service_history (vehicle_id, service_date, mileage, service_type, performed_by) VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([$vehicle_id, $service_date, $mileage, $type, $performed_by]);

    $months = $type === 'Full' ? 12 : 6;
    $next_due = date('Y-m-d', strtotime("+$months months", strtotime($service_date)));

    $update = $pdo->prepare("UPDATE vehicles SET last_service = ?, service_due = ? WHERE id = ?");
    $update->execute([$service_date, $next_due, $vehicle_id]);

    header("Location: service_history.php");
    exit();
}

$vehicles = $pdo->query("SELECT id, plate_number FROM vehicles")->fetchAll();
$records = $pdo->query("SELECT sh.*, v.plate_number FROM service_history sh JOIN vehicles v ON sh.vehicle_id = v.id ORDER BY service_date DESC")->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Service History</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">
<h2>Service History</h2>

<form method="post" class="mb-4">
  <div class="row">
    <div class="col-md-3">
      <label class="form-label">Vehicle</label>
      <select name="vehicle_id" class="form-select" required>
        <option value="">Select</option>
        <?php foreach ($vehicles as $v): ?>
        <option value="<?= $v['id'] ?>"><?= htmlspecialchars($v['plate_number']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-2">
      <label class="form-label">Date</label>
      <input type="date" name="service_date" class="form-control" required>
    </div>
    <div class="col-md-2">
      <label class="form-label">Mileage</label>
      <input type="number" name="mileage" class="form-control" required>
    </div>
    <div class="col-md-2">
      <label class="form-label">Type</label>
      <select name="service_type" class="form-select" required>
        <option value="Full">Full</option>
        <option value="Partial">Partial</option>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">Performed By</label>
      <input type="text" name="performed_by" class="form-control" required>
    </div>
  </div>
  <button type="submit" class="btn btn-primary mt-3">Add Service</button>
</form>

<table class="table table-bordered">
  <thead>
    <tr>
      <th>Date</th>
      <th>Vehicle</th>
      <th>Mileage</th>
      <th>Type</th>
      <th>Performed By</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($records as $r): ?>
    <tr>
      <td><?= date('d-m-Y', strtotime($r['service_date'])) ?></td>
      <td><?= htmlspecialchars($r['plate_number']) ?></td>
      <td><?= $r['mileage'] ?></td>
      <td><?= $r['service_type'] ?></td>
      <td><?= htmlspecialchars($r['performed_by']) ?></td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
</body>
</html>
