<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$is_admin = ($_SESSION['role'] === 'admin');
$current_user_id = $_SESSION['user_id'];

if ($is_admin) {
    $users = $pdo->query("SELECT id, username FROM users ORDER BY username")->fetchAll();
    $selected_user = $_POST['selected_user'] ?? $current_user_id;
} else {
    $selected_user = $current_user_id;
}

if ($is_admin) {
    $vehicles_stmt = $pdo->query("SELECT * FROM vehicles ORDER BY plate_number");
    $vehicles = $vehicles_stmt->fetchAll(PDO::FETCH_ASSOC);
} else {
    $vehicles_stmt = $pdo->prepare("SELECT v.* FROM vehicles v JOIN user_vehicles uv ON uv.vehicle_id = v.id WHERE uv.user_id = ?");
    $vehicles_stmt->execute([$selected_user]);
    $vehicles = $vehicles_stmt->fetchAll(PDO::FETCH_ASSOC);
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['vehicle_id'])) {
    $vehicle_id = $_POST['vehicle_id'];
    $entered_mileage = (int)$_POST['mileage'] ?? 0;

    $current_vehicle_stmt = $pdo->prepare("SELECT mileage FROM vehicles WHERE id = ?");
    $current_vehicle_stmt->execute([$vehicle_id]);
    $vehicle_info = $current_vehicle_stmt->fetch(PDO::FETCH_ASSOC);
    $current_mileage = (int)$vehicle_info['mileage'];

    if ($entered_mileage < $current_mileage) {
        $error = "Entered mileage ($entered_mileage) is less than the current mileage ($current_mileage). Please enter a valid number.";
    } else {
        $checklist = [
            'tyres' => $_POST['tyres'] ?? 'no',
            'lights' => $_POST['lights'] ?? 'no',
            'oil' => $_POST['oil'] ?? 'no',
            'brakes' => $_POST['brakes'] ?? 'no',
            'windscreen' => $_POST['windscreen'] ?? 'no',
            'damage' => $_POST['damage'] ?? 'no',
            'leaks' => $_POST['leaks'] ?? 'no'
        ];

        $upload_dir = 'uploads/';
        if (!file_exists($upload_dir)) mkdir($upload_dir, 0755, true);

        $photo_paths = [];
        foreach ($_FILES['photos']['tmp_name'] as $i => $tmp_name) {
            if ($_FILES['photos']['error'][$i] === UPLOAD_ERR_OK) {
                $filename = basename($_FILES['photos']['name'][$i]);
                $path = $upload_dir . time() . '_' . $filename;
                move_uploaded_file($tmp_name, $path);
                $photo_paths[] = $path;
            }
        }

        $signature_path = '';
        if (!empty($_POST['signature_data'])) {
            $sig_data = explode(',', $_POST['signature_data'])[1];
            $sig_bin = base64_decode($sig_data);
            $signature_path = $upload_dir . 'signature_' . time() . '.png';
            file_put_contents($signature_path, $sig_bin);
        }

$stmt = $pdo->prepare("INSERT INTO daily_checks (date, time, driver_id, vehicle_id, checklist_data, notes, photo_paths, signature_path)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->execute([
    date('Y-m-d'),
    date('H:i:s'),
    $selected_user,
    $vehicle_id,
    json_encode($checklist),
    $_POST['notes'],
    json_encode($photo_paths),
    $signature_path
]);

        if ($entered_mileage > $current_mileage) {
            $update_stmt = $pdo->prepare("UPDATE vehicles SET mileage = ? WHERE id = ?");
            $update_stmt->execute([$entered_mileage, $vehicle_id]);
        }

        $success = "Check submitted successfully.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Daily Check with Mileage</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
  <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
  <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jSignature/2.1.3/jSignature.min.js"></script>
</head>
<body class="container py-4">
<h2>Daily Vehicle Check</h2>

<?php if ($error): ?>
    <div class="alert alert-danger"><?= $error ?></div>
<?php elseif ($success): ?>
    <div class="alert alert-success"><?= $success ?></div>
<?php endif; ?>

<form method="post" enctype="multipart/form-data" class="row g-3">
<?php if ($is_admin): ?>
    <div class="col-md-6">
        <label class="form-label">Select User</label>
        <select name="selected_user" class="form-select" onchange="this.form.submit()">
            <option value="">-- Select User --</option>
            <?php foreach ($users as $u): ?>
                <option value="<?= $u['id'] ?>" <?= $selected_user == $u['id'] ? 'selected' : '' ?>>
                    <?= htmlspecialchars($u['username']) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>
<?php endif; ?>

<div class="col-md-12">
    <label class="form-label">Vehicle</label>
    <select name="vehicle_id" class="form-select" required>
        <?php foreach ($vehicles as $v): ?>
            <option value="<?= $v['id'] ?>"><?= $v['plate_number'] ?> - <?= $v['make'] ?> <?= $v['model'] ?> (Current Mileage: <?= $v['mileage'] ?>)</option>
        <?php endforeach; ?>
    </select>
</div>

<div class="col-md-12">
    <label class="form-label">Current Mileage</label>
    <input type="number" name="mileage" class="form-control" required value="<?= htmlspecialchars($_POST['mileage'] ?? '') ?>">
</div>

<?php
$checks = ['tyres','lights','oil','brakes','windscreen','damage','leaks'];
foreach ($checks as $check): ?>
<div class="col-md-12">
    <label><input type="checkbox" name="<?= $check ?>" value="yes" <?= ($_POST[$check] ?? '') === 'yes' ? 'checked' : '' ?>> <?= ucwords(str_replace('_', ' ', $check)) ?></label>
</div>
<?php endforeach; ?>

<div class="col-md-12">
    <label class="form-label">Notes</label>
    <textarea name="notes" class="form-control"><?= htmlspecialchars($_POST['notes'] ?? '') ?></textarea>
</div>

<div class="col-md-12">
    <label class="form-label">Upload Photos</label>
    <input type="file" name="photos[]" class="form-control" multiple accept="image/*">
</div>

<div class="col-md-12">
    <label class="form-label">Signature</label>
    <div id="signature-pad" style="border: 1px solid #ccc; height: 150px; background-color: #fff;"></div>
    <textarea id="signature_data" name="signature_data" style="display:none;"></textarea>
    <button type="button" class="btn btn-secondary mt-2" id="clear-signature">Clear Signature</button>
</div>

<div class="col-md-12">
    <button class="btn btn-primary" type="submit">Submit</button>
</div>
</form>

<script>
$(document).ready(function() {
    $("#signature-pad").jSignature({'UndoButton': true});
    $('#clear-signature').on('click', function(e) {
        e.preventDefault();
        $('#signature-pad').jSignature('reset');
        $('#signature_data').val('');
    });
    $('form').on('submit', function() {
        var datapair = $("#signature-pad").jSignature("getData", "image");
        $('#signature_data').val("data:" + datapair[0] + "," + datapair[1]);
    });
});
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
