<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$check_id = $_GET['id'] ?? null;
if (!$check_id) {
    die("Check ID not provided.");
}

$stmt = $pdo->prepare("SELECT c.*, u.username, v.plate_number FROM checks c
  JOIN users u ON c.user_id = u.id
  JOIN vehicles v ON c.vehicle_id = v.id
  WHERE c.id = ?");
$stmt->execute([$check_id]);
$check = $stmt->fetch();

if (!$check) {
    die("Check not found.");
}

$photos = $pdo->prepare("SELECT file_path FROM check_photos WHERE check_id = ?");
$photos->execute([$check_id]);
$photos = $photos->fetchAll();

$sig = $pdo->prepare("SELECT file_path FROM check_signatures WHERE check_id = ?");
$sig->execute([$check_id]);
$signature = $sig->fetchColumn();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>View Check</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">
<h2>Check Details</h2>
<p><strong>Date:</strong> <?= date('d-m-Y', strtotime($check['submitted_at'])) ?></p>
<p><strong>Driver:</strong> <?= htmlspecialchars($check['username']) ?></p>
<p><strong>Vehicle:</strong> <?= htmlspecialchars($check['plate_number']) ?></p>
<p><strong>Mileage:</strong> <?= $check['mileage'] ?></p>

<?php if ($photos): ?>
<h5>Photos:</h5>
<div class="row">
  <?php foreach ($photos as $p): ?>
    <div class="col-md-3 mb-3">
      <img src="<?= $p['file_path'] ?>" alt="Check Photo" class="img-fluid img-thumbnail">
    </div>
  <?php endforeach; ?>
</div>
<?php endif; ?>

<?php if ($signature): ?>
<h5>Signature:</h5>
<img src="<?= $signature ?>" alt="Signature" class="img-fluid border" style="max-width: 400px;">
<?php endif; ?>

<a href="reports.php" class="btn btn-secondary mt-3">Back to Reports</a>
</body>
</html>
