<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.php");
    exit();
}

$check_id = $_GET['id'] ?? null;
if (!$check_id) {
    die("No check ID provided.");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $mileage = (int)$_POST['mileage'];
    $pdo->prepare("UPDATE checks SET mileage = ? WHERE id = ?")->execute([$mileage, $check_id]);
    header("Location: reports.php");
    exit();
}

$stmt = $pdo->prepare("SELECT c.*, v.plate_number FROM checks c JOIN vehicles v ON c.vehicle_id = v.id WHERE c.id = ?");
$stmt->execute([$check_id]);
$check = $stmt->fetch();

if (!$check) {
    die("Check not found.");
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Edit Check</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">
<h2>Edit Vehicle Check</h2>
<form method="post">
  <div class="mb-3">
    <label class="form-label">Vehicle</label>
    <input type="text" class="form-control" value="<?= htmlspecialchars($check['plate_number']) ?>" disabled>
  </div>
  <div class="mb-3">
    <label class="form-label">Mileage</label>
    <input type="number" name="mileage" class="form-control" value="<?= $check['mileage'] ?>" required>
  </div>
  <button type="submit" class="btn btn-primary">Save Changes</button>
</form>
</body>
</html>
