<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

if (!isset($_GET['id'])) {
    echo "No check ID provided.";
    exit();
}

$check_id = $_GET['id'];
$stmt = $pdo->prepare("SELECT dc.*, u.username, v.plate_number, v.make, v.model 
                       FROM daily_checks dc
                       JOIN users u ON dc.driver_id = u.id
                       JOIN vehicles v ON dc.vehicle_id = v.id
                       WHERE dc.id = ?");
$stmt->execute([$check_id]);
$check = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$check) {
    echo "Check not found.";
    exit();
}

$checklist = json_decode($check['checklist_data'], true);
$photos = json_decode($check['photo_paths'], true);
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>View Check</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">
<h2>View Vehicle Check</h2>
<p><strong>Date:</strong> <?= htmlspecialchars($check['date']) ?> <?= htmlspecialchars($check['time']) ?></p>
<p><strong>Driver:</strong> <?= htmlspecialchars($check['username']) ?></p>
<p><strong>Vehicle:</strong> <?= htmlspecialchars($check['plate_number'] . ' - ' . $check['make'] . ' ' . $check['model']) ?></p>

<h4>Checklist:</h4>
<ul>
<?php foreach ($checklist as $item => $value): ?>
    <li><?= ucfirst($item) ?>: <?= $value === 'yes' ? '✅' : '❌' ?></li>
<?php endforeach; ?>
</ul>

<h4>Notes:</h4>
<p><?= nl2br(htmlspecialchars($check['notes'])) ?></p>

<h4>Photos:</h4>
<div class="row">
<?php foreach ($photos as $photo): ?>
    <div class="col-md-3">
        <img src="<?= htmlspecialchars($photo) ?>" class="img-fluid img-thumbnail mb-2">
    </div>
<?php endforeach; ?>
</div>

<?php if (!empty($check['signature_path'])): ?>
<h4>Signature:</h4>
<img src="<?= htmlspecialchars($check['signature_path']) ?>" class="img-fluid img-thumbnail">
<?php endif; ?>
</body>
</html>
