<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.php");
    exit();
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $plate = $_POST['plate_number'];
    $make = $_POST['make'];
    $model = $_POST['model'];
    $mileage = $_POST['mileage'];

    if (!$plate || !$make || !$model || $mileage < 0) {
        $error = "All fields are required and mileage must be 0 or greater.";
    } else {
        $stmt = $pdo->prepare("INSERT INTO vehicles (plate_number, make, model, mileage) VALUES (?, ?, ?, ?)");
        $stmt->execute([$plate, $make, $model, $mileage]);
        header("Location: vehicles.php");
        exit();
    }
}
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Add Vehicle</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">
  <h2>Add New Vehicle</h2>
  <?php if ($error): ?>
    <div class="alert alert-danger"><?= $error ?></div>
  <?php endif; ?>
  <form method="post">
    <div class="mb-3">
      <label class="form-label">Plate Number</label>
      <input type="text" name="plate_number" class="form-control" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Make</label>
      <input type="text" name="make" class="form-control" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Model</label>
      <input type="text" name="model" class="form-control" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Mileage</label>
      <input type="number" name="mileage" class="form-control" min="0" required>
    </div>
    <button type="submit" class="btn btn-primary">Add Vehicle</button>
    <a href="vehicles.php" class="btn btn-secondary">Cancel</a>
  </form>
</body>
</html>