<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$is_admin = $_SESSION['role'] === 'admin';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $vehicle_id = $_POST['vehicle_id'];
    $user_id = $is_admin ? $_POST['user_id'] : $_SESSION['user_id'];
    $mileage = (int)$_POST['mileage'];

    $vehicle = $pdo->prepare("SELECT mileage FROM vehicles WHERE id = ?");
    $vehicle->execute([$vehicle_id]);
    $vehicleData = $vehicle->fetch();

    if ($mileage < $vehicleData['mileage']) {
        $_SESSION['error'] = "Submitted mileage is lower than current mileage ({$vehicleData['mileage']}). Please correct it.";
        $_SESSION['form_data'] = $_POST;
        header("Location: check.php");
        exit();
    }

    $check = $pdo->prepare("INSERT INTO checks (user_id, vehicle_id, mileage, submitted_at) VALUES (?, ?, ?, NOW())");
    $check->execute([$user_id, $vehicle_id, $mileage]);

    $pdo->prepare("UPDATE vehicles SET mileage = ? WHERE id = ?")->execute([$mileage, $vehicle_id]);

    $check_id = $pdo->lastInsertId();

    // Handle uploads
    foreach ($_FILES['photos']['tmp_name'] as $index => $tmpName) {
        if (is_uploaded_file($tmpName)) {
            $filename = basename($_FILES['photos']['name'][$index]);
            $targetPath = "uploads/photos/" . time() . "_" . $filename;
            move_uploaded_file($tmpName, $targetPath);

            $stmt = $pdo->prepare("INSERT INTO check_photos (check_id, file_path) VALUES (?, ?)");
            $stmt->execute([$check_id, $targetPath]);
        }
    }

    if (!empty($_POST['signature'])) {
        $sigData = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $_POST['signature']));
        $sigFile = "uploads/signatures/" . time() . "_signature.png";
        file_put_contents($sigFile, $sigData);

        $stmt = $pdo->prepare("INSERT INTO check_signatures (check_id, file_path) VALUES (?, ?)");
        $stmt->execute([$check_id, $sigFile]);
    }

    header("Location: dashboard.php");
    exit();
}

$vehicles = $pdo->query("SELECT id, plate_number FROM vehicles")->fetchAll();
$users = $is_admin ? $pdo->query("SELECT id, username FROM users")->fetchAll() : [];
$form_data = $_SESSION['form_data'] ?? [];
unset($_SESSION['form_data']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Submit Vehicle Check</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/signature_pad@4.0.0/dist/signature-pad.min.css">
</head>
<body class="container py-4">
<?php if (isset($_SESSION['error'])): ?>
  <div class="alert alert-danger"><?= $_SESSION['error'] ?></div>
  <?php unset($_SESSION['error']); ?>
<?php endif; ?>

<h2>Vehicle Check Form</h2>
<form action="check.php" method="post" enctype="multipart/form-data">
  <?php if ($is_admin): ?>
  <div class="mb-3">
    <label class="form-label">User</label>
    <select name="user_id" class="form-select" required>
      <option value="">Select User</option>
      <?php foreach ($users as $u): ?>
        <option value="<?= $u['id'] ?>"><?= htmlspecialchars($u['username']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <?php endif; ?>

  <div class="mb-3">
    <label class="form-label">Vehicle</label>
    <select name="vehicle_id" class="form-select" required>
      <option value="">Select Vehicle</option>
      <?php foreach ($vehicles as $v): ?>
        <option value="<?= $v['id'] ?>"><?= htmlspecialchars($v['plate_number']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="mb-3">
    <label class="form-label">Mileage</label>
    <input type="number" name="mileage" class="form-control" value="<?= $form_data['mileage'] ?? '' ?>" required>
  </div>

  <div class="mb-3">
    <label class="form-label">Upload Photos</label>
    <input type="file" name="photos[]" class="form-control" multiple>
  </div>

  <div class="mb-3">
    <label class="form-label">Signature</label><br>
    <canvas id="signature-pad" class="border" width=400 height=200></canvas><br>
    <input type="hidden" name="signature" id="signature">
    <button type="button" class="btn btn-secondary btn-sm" onclick="clearPad()">Clear</button>
  </div>

  <button type="submit" class="btn btn-primary">Submit Check</button>
</form>

<script src="https://cdn.jsdelivr.net/npm/signature_pad@4.0.0/dist/signature_pad.umd.min.js"></script>
<script>
const canvas = document.getElementById('signature-pad');
const signaturePad = new SignaturePad(canvas);
const sigInput = document.getElementById('signature');

document.querySelector("form").addEventListener("submit", function() {
  if (!signaturePad.isEmpty()) {
    sigInput.value = signaturePad.toDataURL();
  }
});

function clearPad() {
  signaturePad.clear();
}
</script>
</body>
</html>
