<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $plate = $_POST['plate_number'];
    $make = $_POST['make'];
    $model = $_POST['model'];
    $mileage = $_POST['mileage'];
    $stmt = $pdo->prepare("INSERT INTO vehicles (plate_number, make, model, mileage) VALUES (?, ?, ?, ?)");
    $stmt->execute([$plate, $make, $model, $mileage]);
    header("Location: vehicles.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Add Vehicle</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">
<h2>Add Vehicle</h2>
<form method="post">
  <div class="mb-3">
    <label class="form-label">Plate Number</label>
    <input type="text" name="plate_number" class="form-control" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Make</label>
    <input type="text" name="make" class="form-control" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Model</label>
    <input type="text" name="model" class="form-control" required>
  </div>
  <div class="mb-3">
    <label class="form-label">Mileage</label>
    <input type="number" name="mileage" class="form-control" required>
  </div>
  <button type="submit" class="btn btn-primary">Add Vehicle</button>
</form>
</body>
</html>
