<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: login.php");
    exit();
}

// Update user
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_user'])) {
    $id = $_POST['user_id'];
    $username = $_POST['username'];
    $email = $_POST['email'];
    $role = $_POST['role'];
    $status = $_POST['status'];
    $password_sql = "";

    if (!empty($_POST['password'])) {
        $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $password_sql = ", password = '$password'";
    }

    $stmt = $pdo->prepare("UPDATE users SET username = ?, email = ?, role = ?, status = ? $password_sql WHERE id = ?");
    $stmt->execute([$username, $email, $role, $status, $id]);
    header("Location: user_management.php");
    exit();
}

// Add user
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_user'])) {
    $username = $_POST['username'];
    $email = $_POST['email'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $role = $_POST['role'];
    $stmt = $pdo->prepare("INSERT INTO users (username, email, password, role, status) VALUES (?, ?, ?, ?, 'active')");
    $stmt->execute([$username, $email, $password, $role]);
    header("Location: user_management.php");
    exit();
}

// Delete user
if (isset($_GET['delete'])) {
    $stmt = $pdo->prepare("DELETE FROM users WHERE id = ?");
    $stmt->execute([$_GET['delete']]);
    header("Location: user_management.php");
    exit();
}

// Fetch all users
$users = $pdo->query("SELECT * FROM users ORDER BY username")->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>User Management</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script>
    function populateEditForm(id, username, email, role, status) {
        document.getElementById('edit_user_id').value = id;
        document.getElementById('edit_username').value = username;
        document.getElementById('edit_email').value = email;
        document.getElementById('edit_role').value = role;
        document.getElementById('edit_status').value = status;
    }
  </script>
</head>
<body class="container py-4">
<h2>Manage Users</h2>

<!-- Add user form -->
<form method="post" class="mb-4">
  <input type="hidden" name="add_user" value="1">
  <div class="row">
    <div class="col-md-2"><input type="text" name="username" class="form-control" placeholder="Username" required></div>
    <div class="col-md-3"><input type="email" name="email" class="form-control" placeholder="Email" required></div>
    <div class="col-md-2"><input type="password" name="password" class="form-control" placeholder="Password" required></div>
    <div class="col-md-2">
      <select name="role" class="form-select" required>
        <option value="user">User</option>
        <option value="admin">Admin</option>
      </select>
    </div>
    <div class="col-md-2 d-grid"><button type="submit" class="btn btn-success">Add User</button></div>
  </div>
</form>

<!-- Edit user modal -->
<form method="post" class="mb-4 border p-3 bg-light">
  <input type="hidden" name="update_user" value="1">
  <input type="hidden" name="user_id" id="edit_user_id">
  <h5>Edit User</h5>
  <div class="row">
    <div class="col-md-2"><input type="text" name="username" id="edit_username" class="form-control" placeholder="Username" required></div>
    <div class="col-md-3"><input type="email" name="email" id="edit_email" class="form-control" placeholder="Email" required></div>
    <div class="col-md-2"><input type="password" name="password" class="form-control" placeholder="New Password (optional)"></div>
    <div class="col-md-2">
      <select name="role" id="edit_role" class="form-select" required>
        <option value="user">User</option>
        <option value="admin">Admin</option>
      </select>
    </div>
    <div class="col-md-2">
      <select name="status" id="edit_status" class="form-select" required>
        <option value="active">Active</option>
        <option value="disabled">Disabled</option>
      </select>
    </div>
    <div class="col-md-1 d-grid"><button type="submit" class="btn btn-primary">Save</button></div>
  </div>
</form>

<!-- User table -->
<table class="table table-bordered">
  <thead>
    <tr>
      <th>Username</th>
      <th>Email</th>
      <th>Role</th>
      <th>Status</th>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($users as $u): ?>
    <tr>
      <td><?= htmlspecialchars($u['username']) ?></td>
      <td><?= htmlspecialchars($u['email']) ?></td>
      <td><?= $u['role'] ?></td>
      <td><?= $u['status'] ?></td>
      <td>
        <?php if ($_SESSION['user_id'] != $u['id']): ?>
        <button type="button" class="btn btn-warning btn-sm" onclick="populateEditForm('<?= $u['id'] ?>', '<?= $u['username'] ?>', '<?= $u['email'] ?>', '<?= $u['role'] ?>', '<?= $u['status'] ?>')">Edit</button>
        <a href="user_management.php?delete=<?= $u['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</a>
        <?php else: ?>
        <em>Logged in</em>
        <?php endif; ?>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
</body>
</html>
