<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$is_admin = ($_SESSION['role'] === 'admin');

$filter_user = $_GET['user'] ?? '';
$filter_vehicle = $_GET['vehicle'] ?? '';
$filter_date = $_GET['date'] ?? '';

$query = "SELECT dc.*, u.username, v.plate_number, v.make, v.model FROM daily_checks dc
          JOIN users u ON dc.driver_id = u.id
          JOIN vehicles v ON dc.vehicle_id = v.id WHERE 1=1";

$params = [];

if (!empty($filter_user)) {
    $query .= " AND dc.driver_id = ?";
    $params[] = $filter_user;
}
if (!empty($filter_vehicle)) {
    $query .= " AND dc.vehicle_id = ?";
    $params[] = $filter_vehicle;
}
if (!empty($filter_date)) {
    $query .= " AND dc.date = ?";
    $params[] = $filter_date;
}

$query .= " ORDER BY dc.date DESC";

$stmt = $pdo->prepare($query);
$stmt->execute($params);
$checks = $stmt->fetchAll();

$users = $pdo->query("SELECT id, username FROM users")->fetchAll();
$vehicles = $pdo->query("SELECT id, plate_number, make, model FROM vehicles")->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Vehicle Check Reports</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .check-icon { font-size: 1.2rem; }
    .check-icon.yes { color: green; }
    .check-icon.no { color: red; }
  </style>
</head>
<body class="container py-4">
<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <a class="navbar-brand" href="#">Vehicle Check</a>
    <div class="collapse navbar-collapse">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item"><a class="nav-link" href="dashboard.php">Dashboard</a></li>
        <li class="nav-item"><a class="nav-link" href="check.php">Submit Check</a></li>
        <li class="nav-item"><a class="nav-link active" href="reports.php">Reports</a></li>
        <?php if ($_SESSION['role'] === 'admin'): ?>
          <li class="nav-item"><a class="nav-link" href="vehicles.php">Manage Vehicles</a></li>
          <li class="nav-item"><a class="nav-link" href="service_history.php">Service History</a></li>
        <?php endif; ?>
        <li class="nav-item"><a class="nav-link" href="logout.php">Logout</a></li>
      </ul>
    </div>
  </div>
</nav>

<h2>Reports</h2>

<form method="get" class="row g-3 mb-4">
  <div class="col-md-3">
    <label class="form-label">Driver</label>
    <select name="user" class="form-select">
      <option value="">All Drivers</option>
      <?php foreach ($users as $u): ?>
        <option value="<?= $u['id'] ?>" <?= $filter_user == $u['id'] ? 'selected' : '' ?>>
          <?= htmlspecialchars($u['username']) ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-md-3">
    <label class="form-label">Vehicle</label>
    <select name="vehicle" class="form-select">
      <option value="">All Vehicles</option>
      <?php foreach ($vehicles as $v): ?>
        <option value="<?= $v['id'] ?>" <?= $filter_vehicle == $v['id'] ? 'selected' : '' ?>>
          <?= $v['plate_number'] ?> - <?= $v['make'] ?> <?= $v['model'] ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-md-3">
    <label class="form-label">Date</label>
    <input type="date" name="date" value="<?= htmlspecialchars($filter_date) ?>" class="form-control">
  </div>
  <div class="col-md-3 d-flex align-items-end">
    <button type="submit" class="btn btn-primary me-2">Filter</button>
    <a href="export_pdf.php?<?= http_build_query($_GET) ?>" class="btn btn-danger">Export PDF</a>
  </div>
</form>

<table class="table table-bordered table-striped">
  <thead>
    <tr>
      <th>Date & Time</th>
      <th>Driver</th>
      <th>Vehicle</th>
      <th>Checklist</th>
      <th>Notes</th>
      <?php if ($is_admin): ?>
      <th>Actions</th>
      <?php endif; ?>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($checks as $check): 
      $checklist = json_decode($check['checklist_data'], true); ?>
      <tr>
        <td><?= date('d-m-Y', strtotime($check['date'])) ?> <?= substr($check['time'], 0, 5) ?></td>
        <td><?= htmlspecialchars($check['username']) ?></td>
        <td><?= $check['plate_number'] ?> - <?= $check['make'] ?> <?= $check['model'] ?></td>
        <td>
          <?php foreach ($checklist as $item => $status): ?>
            <?= ucfirst($item) ?>:
            <span class="check-icon <?= $status === 'yes' ? 'yes' : 'no' ?>">
              <?= $status === 'yes' ? '✅' : '❌' ?>
            </span><br>
          <?php endforeach; ?>
        </td>
        <td><?= nl2br(htmlspecialchars($check['notes'])) ?></td>
        <?php if ($is_admin): ?>
        <td>
          <a href="view_check.php?id=<?= $check['id'] ?>" class="btn btn-info btn-sm">View</a>
          <a href="edit_check.php?id=<?= $check['id'] ?>" class="btn btn-warning btn-sm">Edit</a>
          <a href="delete_check.php?id=<?= $check['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Delete this record?')">Delete</a>
        </td>
        <?php endif; ?>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
</body>
</html>
