<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$is_admin = $_SESSION['role'] === 'admin';

// Load vehicles
$stmt = $pdo->query("SELECT * FROM vehicles ORDER BY plate_number");
$vehicles = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Dashboard</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <a class="navbar-brand" href="#">Vehicle Check</a>
    <div class="collapse navbar-collapse">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item"><a class="nav-link" href="dashboard.php">Dashboard</a></li>
        <li class="nav-item"><a class="nav-link" href="check.php">Submit Check</a></li>
        <li class="nav-item"><a class="nav-link" href="reports.php">Reports</a></li>
        <?php if ($is_admin): ?>
          <li class="nav-item"><a class="nav-link" href="vehicles.php">Manage Vehicles</a></li>
          <li class="nav-item"><a class="nav-link" href="service_history.php">Service History</a></li>
        <?php endif; ?>
        <li class="nav-item"><a class="nav-link" href="logout.php">Logout</a></li>
      </ul>
    </div>
  </div>
</nav>

<div class="container">
  <h2>Welcome<?= isset($_SESSION['username']) ? ', ' . htmlspecialchars($_SESSION['username']) : '' ?></h2>

  <h4 class="mt-4">Vehicles</h4>
  <div class="row">
    <?php foreach ($vehicles as $vehicle): ?>
      <div class="col-md-4 mb-3">
        <div class="card">
          <div class="card-body">
            <h5 class="card-title"><?= htmlspecialchars($vehicle['plate_number']) ?></h5>
            <p class="card-text">
              <?= htmlspecialchars($vehicle['make']) ?> <?= htmlspecialchars($vehicle['model']) ?><br>
              Mileage: <?= $vehicle['mileage'] ?><br>
              Last Service: <?= isset($vehicle['last_service']) && $vehicle['last_service'] ? date('d-m-Y', strtotime($vehicle['last_service'])) : 'N/A' ?><br>
              Next Due: <?= isset($vehicle['service_due']) && $vehicle['service_due'] ? date('d-m-Y', strtotime($vehicle['service_due'])) : 'N/A' ?>
            </p>
            <?php if ($is_admin): ?>
              <a href="service_history.php" class="btn btn-outline-secondary btn-sm">Service History</a>
            <?php endif; ?>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>
</body>
</html>
