<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$is_admin = ($_SESSION['role'] === 'admin');
$user_id = $_SESSION['user_id'];
$username = $_SESSION['username'] ?? '';

// Fetch vehicles
if ($is_admin) {
    $stmt = $pdo->query("SELECT * FROM vehicles");
} else {
    $stmt = $pdo->prepare("SELECT v.* FROM vehicles v
                           JOIN user_vehicles uv ON uv.vehicle_id = v.id
                           WHERE uv.user_id = ?");
    $stmt->execute([$user_id]);
}
$vehicles = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Dashboard</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">
<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <a class="navbar-brand" href="#">Vehicle Check</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav me-auto">
        <li class="nav-item"><a class="nav-link active" href="dashboard.php">Dashboard</a></li>
        <li class="nav-item"><a class="nav-link" href="check.php">Submit Check</a></li>
        <li class="nav-item"><a class="nav-link" href="reports.php">Reports</a></li>
        <?php if ($is_admin): ?>
        <li class="nav-item"><a class="nav-link" href="vehicles.php">Manage Vehicles</a></li>
        <li class="nav-item"><a class="nav-link" href="service_history.php">Service History</a></li>
        <li class="nav-item"><a class="nav-link" href="user_management.php">User Management</a></li>
        <?php endif; ?>
        <li class="nav-item"><a class="nav-link" href="logout.php">Logout</a></li>
      </ul>
    </div>
  </div>
</nav>

<h3>Welcome, <?= htmlspecialchars($username ?? '') ?></h3>

<h4 class="mt-4">Vehicles</h4>
<table class="table table-bordered table-striped">
  <thead>
    <tr>
      <th>Plate</th>
      <th>Make</th>
      <th>Model</th>
      <th>Mileage</th>
      <th>Last Service</th>
      <th>Next Service Due</th>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($vehicles as $v): ?>
    <tr>
      <td><?= htmlspecialchars($v['plate_number']) ?></td>
      <td><?= htmlspecialchars($v['make']) ?></td>
      <td><?= htmlspecialchars($v['model']) ?></td>
      <td><?= htmlspecialchars($v['mileage']) ?></td>
      <td><?= htmlspecialchars($v['last_service'] ?? 'N/A') ?></td>
      <td><?= htmlspecialchars($v['service_due'] ?? 'N/A') ?></td>
      <td>
        <a href="check.php?vehicle_id=<?= $v['id'] ?>" class="btn btn-sm btn-primary">Check</a>
        <?php if ($is_admin): ?>
        <a href="service_history.php?vehicle_id=<?= $v['id'] ?>" class="btn btn-sm btn-info">Service History</a>
        <?php endif; ?>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
