<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    header('Location: login.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $stmt = $pdo->prepare("INSERT INTO vehicles (plate_number, make, model, last_service, mileage, mot_date, service_due, mot_due, notes) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([
        $_POST['plate_number'],
        $_POST['make'],
        $_POST['model'],
        empty($_POST['last_service']) ? null : $_POST['last_service'],
        is_numeric($_POST['mileage']) ? $_POST['mileage'] : null,
        empty($_POST['mot_date']) ? null : $_POST['mot_date'],
        empty($_POST['service_due']) ? null : $_POST['service_due'],
        empty($_POST['mot_due']) ? null : $_POST['mot_due'],
        $_POST['notes']
    ]);
    header('Location: vehicles.php');
    exit();
}

$vehicles = $pdo->query("SELECT * FROM vehicles ORDER BY plate_number")->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Vehicle Check System</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">

<h2>Vehicle List</h2>
<table class="table table-bordered">
    <thead><tr><th>Plate</th><th>Make</th><th>Model</th><th>Mileage</th><th>Service Due</th><th>MOT Due</th><th>Actions</th></tr></thead>
    <tbody>
    <?php foreach ($vehicles as $v): ?>
    <tr>
        <td><?= htmlspecialchars($v['plate_number']) ?></td>
        <td><?= htmlspecialchars($v['make']) ?></td>
        <td><?= htmlspecialchars($v['model']) ?></td>
        <td><?= htmlspecialchars($v['mileage']) ?></td>
        <td><?= htmlspecialchars($v['service_due']) ?></td>
        <td><?= htmlspecialchars($v['mot_due']) ?></td>
        <td><a class="btn btn-sm btn-warning" href="edit_vehicle.php?id=<?= $v['id'] ?>">Edit</a></td>
    </tr>
    <?php endforeach; ?>
    </tbody>
</table>

<h3>Add New Vehicle</h3>
<form method="post" class="row g-3">
    <div class="col-md-4"><input class="form-control" type="text" name="plate_number" placeholder="Plate" required></div>
    <div class="col-md-4"><input class="form-control" type="text" name="make" placeholder="Make"></div>
    <div class="col-md-4"><input class="form-control" type="text" name="model" placeholder="Model"></div>
    <div class="col-md-4"><input class="form-control" type="date" name="last_service" placeholder="Last Service"></div>
    <div class="col-md-4"><input class="form-control" type="number" name="mileage" placeholder="Mileage"></div>
    <div class="col-md-4"><input class="form-control" type="date" name="mot_date" placeholder="MOT Date"></div>
    <div class="col-md-4"><input class="form-control" type="date" name="service_due" placeholder="Service Due"></div>
    <div class="col-md-4"><input class="form-control" type="date" name="mot_due" placeholder="MOT Due"></div>
    <div class="col-md-12"><textarea class="form-control" name="notes" placeholder="Notes"></textarea></div>
    <div class="col-md-12"><button class="btn btn-success" type="submit">Add Vehicle</button></div>
</form>
<a href="dashboard.php" class="btn btn-secondary mt-3">Back</a>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
