<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    header('Location: login.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['create_user'])) {
        $stmt = $pdo->prepare("INSERT INTO users (username, password, role, email) VALUES (?, ?, ?, ?)");
        $stmt->execute([
            $_POST['username'],
            password_hash($_POST['password'], PASSWORD_DEFAULT),
            $_POST['role'],
            $_POST['email']
        ]);
    } elseif (isset($_POST['assign_vehicle'])) {
        $stmt = $pdo->prepare("INSERT INTO user_vehicles (user_id, vehicle_id) VALUES (?, ?)");
        $stmt->execute([
            $_POST['user_id'],
            $_POST['vehicle_id']
        ]);
    }
}

$users = $pdo->query("SELECT * FROM users")->fetchAll();
$vehicles = $pdo->query("SELECT * FROM vehicles ORDER BY plate_number")->fetchAll();
$user_vehicles = $pdo->query("SELECT uv.user_id, uv.vehicle_id, u.username, v.plate_number FROM user_vehicles uv
JOIN users u ON uv.user_id = u.id
JOIN vehicles v ON uv.vehicle_id = v.id")->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Vehicle Check System</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">

<h2>User Management</h2>
<form method="post" class="row g-3 border rounded p-3 mb-4 bg-light">
    <h5>Create New User</h5>
    <div class="col-md-3">
        <input class="form-control" name="username" placeholder="Username" required>
    </div>
    <div class="col-md-3">
        <input class="form-control" name="password" placeholder="Password" required>
    </div>
    <div class="col-md-3">
        <select class="form-select" name="role">
            <option value="user">User</option>
            <option value="admin">Admin</option>
        </select>
    </div>
    <div class="col-md-3">
        <input class="form-control" name="email" placeholder="Email" required>
    </div>
    <div class="col-12">
        <button class="btn btn-success" name="create_user">Create User</button>
    </div>
</form>

<form method="post" class="row g-3 border rounded p-3 mb-4 bg-light">
    <h5>Assign Vehicle to User</h5>
    <div class="col-md-4">
        <select name="user_id" class="form-select" required>
            <?php foreach ($users as $u): ?>
                <option value="<?= $u['id'] ?>"><?= $u['username'] ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="col-md-4">
        <select name="vehicle_id" class="form-select" required>
            <?php foreach ($vehicles as $v): ?>
                <option value="<?= $v['id'] ?>"><?= $v['plate_number'] ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="col-md-4">
        <button class="btn btn-primary" name="assign_vehicle">Assign</button>
    </div>
</form>

<h4>Assigned Vehicles</h4>
<table class="table table-bordered">
    <thead><tr><th>User</th><th>Vehicle</th></tr></thead>
    <tbody>
        <?php foreach ($user_vehicles as $uv): ?>
            <tr>
                <td><?= htmlspecialchars($uv['username']) ?></td>
                <td><?= htmlspecialchars($uv['plate_number']) ?></td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<p><a href="dashboard.php" class="btn btn-secondary">Back to Dashboard</a></p>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

