<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    header('Location: login.php');
    exit();
}

$checks = $pdo->query("SELECT dc.*, u.username, v.plate_number FROM daily_checks dc JOIN users u ON dc.driver_id = u.id JOIN vehicles v ON dc.vehicle_id = v.id ORDER BY dc.date DESC")->fetchAll();

if (isset($_GET['export']) && $_GET['export'] == 'csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment;filename=check_reports.csv');
    $out = fopen('php://output', 'w');
    fputcsv($out, ['Date', 'Driver', 'Vehicle', 'Checklist', 'Notes']);
    foreach ($checks as $check) {
        fputcsv($out, [
            $check['date'],
            $check['username'],
            $check['plate_number'],
            $check['checklist_data'],
            $check['notes']
        ]);
    }
    fclose($out);
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Vehicle Check System</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">

<h2>Driver Daily Checks</h2>
<p><a href="reports.php?export=csv" class="btn btn-success mb-3">Export as CSV</a></p>
<table class="table table-bordered">
    <thead><tr><th>Date</th><th>Driver</th><th>Vehicle</th><th>Checklist</th><th>Notes</th></tr></thead>
    <tbody>
    <?php foreach ($checks as $c): ?>
        <tr>
            <td><?= $c['date'] ?></td>
            <td><?= htmlspecialchars($c['username']) ?></td>
            <td><?= htmlspecialchars($c['plate_number']) ?></td>
            <td><pre><?= json_encode(json_decode($c['checklist_data']), JSON_PRETTY_PRINT) ?></pre></td>
            <td><?= htmlspecialchars($c['notes']) ?></td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>
<a href="dashboard.php" class="btn btn-secondary">Back</a>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
