<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    header('Location: login.php');
    exit();
}

if (!isset($_GET['id'])) {
    echo "Vehicle ID missing.";
    exit();
}

$id = $_GET['id'];
$vehicle = $pdo->prepare("SELECT * FROM vehicles WHERE id = ?");
$vehicle->execute([$id]);
$vehicle = $vehicle->fetch();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $stmt = $pdo->prepare("UPDATE vehicles SET plate_number = ?, make = ?, model = ?, last_service = ?, mileage = ?, mot_date = ?, service_due = ?, mot_due = ?, notes = ? WHERE id = ?");
    $stmt->execute([
        $_POST['plate_number'],
        $_POST['make'],
        $_POST['model'],
        empty($_POST['last_service']) ? null : $_POST['last_service'],
        is_numeric($_POST['mileage']) ? $_POST['mileage'] : null,
        empty($_POST['mot_date']) ? null : $_POST['mot_date'],
        empty($_POST['service_due']) ? null : $_POST['service_due'],
        empty($_POST['mot_due']) ? null : $_POST['mot_due'],
        $_POST['notes'],
        $id
    ]);
    header('Location: vehicles.php');
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Vehicle Check System</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">

<h2>Edit Vehicle</h2>
<form method="post" class="row g-3">
  <div class="col-md-4">
    <label class="form-label">Plate</label>
    <input class="form-control" name="plate_number" value="<?= htmlspecialchars($vehicle['plate_number']) ?>" required>
  </div>
  <div class="col-md-4">
    <label class="form-label">Make</label>
    <input class="form-control" name="make" value="<?= htmlspecialchars($vehicle['make']) ?>">
  </div>
  <div class="col-md-4">
    <label class="form-label">Model</label>
    <input class="form-control" name="model" value="<?= htmlspecialchars($vehicle['model']) ?>">
  </div>
  <div class="col-md-4">
    <label class="form-label">Last Service</label>
    <input type="date" class="form-control" name="last_service" value="<?= $vehicle['last_service'] ?>">
  </div>
  <div class="col-md-4">
    <label class="form-label">Mileage</label>
    <input class="form-control" type="number" name="mileage" value="<?= $vehicle['mileage'] ?>">
  </div>
  <div class="col-md-4">
    <label class="form-label">MOT Date</label>
    <input type="date" class="form-control" name="mot_date" value="<?= $vehicle['mot_date'] ?>">
  </div>
  <div class="col-md-4">
    <label class="form-label">Service Due</label>
    <input type="date" class="form-control" name="service_due" value="<?= $vehicle['service_due'] ?>">
  </div>
  <div class="col-md-4">
    <label class="form-label">MOT Due</label>
    <input type="date" class="form-control" name="mot_due" value="<?= $vehicle['mot_due'] ?>">
  </div>
  <div class="col-md-12">
    <label class="form-label">Notes</label>
    <textarea class="form-control" name="notes"><?= htmlspecialchars($vehicle['notes']) ?></textarea>
  </div>
  <div class="col-12">
    <button class="btn btn-primary">Save Changes</button>
    <a href="vehicles.php" class="btn btn-secondary">Cancel</a>
  </div>
</form>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

