<?php
ini_set('session.save_path', __DIR__ . '/tmp_sessions');
session_start();
require_once 'config/db.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$is_admin = ($_SESSION['role'] === 'admin');
$current_user_id = $_SESSION['user_id'];

if ($is_admin) {
    $users = $pdo->query("SELECT id, username FROM users ORDER BY username")->fetchAll();
    $selected_user = $_POST['selected_user'] ?? $current_user_id;
} else {
    $selected_user = $current_user_id;
}

$vehicles_stmt = $pdo->prepare("SELECT v.* FROM vehicles v JOIN user_vehicles uv ON uv.vehicle_id = v.id WHERE uv.user_id = ?");
$vehicles_stmt->execute([$selected_user]);
$vehicles = $vehicles_stmt->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['vehicle_id'])) {
    $checklist = [
        'tyres' => $_POST['tyres'] ?? 'no',
        'lights' => $_POST['lights'] ?? 'no',
        'oil' => $_POST['oil'] ?? 'no',
        'brakes' => $_POST['brakes'] ?? 'no',
        'windscreen' => $_POST['windscreen'] ?? 'no',
        'damage' => $_POST['damage'] ?? 'no',
        'leaks' => $_POST['leaks'] ?? 'no'
    ];

    $upload_dir = 'uploads/';
    $photo_paths = [];
    foreach ($_FILES['photos']['tmp_name'] as $i => $tmp_name) {
        if ($_FILES['photos']['error'][$i] === UPLOAD_ERR_OK) {
            $filename = basename($_FILES['photos']['name'][$i]);
            $path = $upload_dir . time() . '_' . $filename;
            move_uploaded_file($tmp_name, $path);
            $photo_paths[] = $path;
        }
    }

    $signature_path = '';
    if (!empty($_POST['signature_data'])) {
        $sig_data = explode(',', $_POST['signature_data'])[1];
        $sig_bin = base64_decode($sig_data);
        $signature_path = $upload_dir . 'signature_' . time() . '.png';
        file_put_contents($signature_path, $sig_bin);
    }

    $stmt = $pdo->prepare("INSERT INTO daily_checks (date, driver_id, vehicle_id, checklist_data, notes, photo_paths, signature_path)
        VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([
        date('Y-m-d'),
        $selected_user,
        $_POST['vehicle_id'],
        json_encode($checklist),
        $_POST['notes'],
        json_encode($photo_paths),
        $signature_path
    ]);

    echo "<p class='text-success'>Check submitted successfully.</p>";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Daily Check</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-signature/1.2.1/jquery.signature.min.css">
  <style> .kbw-signature { width: 100%; height: 150px;} </style>
</head>
<body class="container py-4">
<h2>Daily Vehicle Check</h2>
<form method="post" enctype="multipart/form-data" class="row g-3">
<?php if ($is_admin): ?>
    <div class="col-md-6">
        <label class="form-label">Select User</label>
        <select name="selected_user" class="form-select" onchange="this.form.submit()">
            <option value="">-- Select User --</option>
            <?php foreach ($users as $u): ?>
                <option value="<?= $u['id'] ?>" <?= $selected_user == $u['id'] ? 'selected' : '' ?>>
                    <?= htmlspecialchars($u['username']) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>
<?php endif; ?>

<div class="col-md-12">
    <label class="form-label">Vehicle</label>
    <select name="vehicle_id" class="form-select" required>
        <?php foreach ($vehicles as $v): ?>
            <option value="<?= $v['id'] ?>"><?= $v['plate_number'] ?> - <?= $v['make'] ?> <?= $v['model'] ?></option>
        <?php endforeach; ?>
    </select>
</div>

<div class="col-md-12"><label><input type="checkbox" name="tyres" value="yes"> Tyres</label></div>
<div class="col-md-12"><label><input type="checkbox" name="lights" value="yes"> Lights</label></div>
<div class="col-md-12"><label><input type="checkbox" name="oil" value="yes"> Oil</label></div>
<div class="col-md-12"><label><input type="checkbox" name="brakes" value="yes"> Brakes</label></div>
<div class="col-md-12"><label><input type="checkbox" name="windscreen" value="yes"> Windscreen</label></div>
<div class="col-md-12"><label><input type="checkbox" name="damage" value="yes"> Body Damage</label></div>
<div class="col-md-12"><label><input type="checkbox" name="leaks" value="yes"> Leaks</label></div>

<div class="col-md-12">
    <label class="form-label">Notes</label>
    <textarea name="notes" class="form-control"></textarea>
</div>

<div class="col-md-12">
    <label class="form-label">Upload Photos</label>
    <input type="file" name="photos[]" class="form-control" multiple accept="image/*">
</div>

<div class="col-md-12">
    <label class="form-label">Signature</label>
    <div id="signature-pad" class="kbw-signature"></div>
    <textarea id="signature_data" name="signature_data" style="display:none;"></textarea>
    <button type="button" class="btn btn-secondary mt-2" onclick="$('#signature-pad').signature('clear')">Clear</button>
</div>

<div class="col-md-12">
    <button class="btn btn-primary" onclick="saveSignature()">Submit</button>
</div>
</form>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-signature/1.2.1/jquery.signature.min.js"></script>
<script>
$('#signature-pad').signature({syncField: '#signature_data', syncFormat: 'PNG'});
function saveSignature() {
    document.forms[0].submit();
}
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
